/* -LICENSE-START-
 ** Copyright (c) 2016 Blackmagic Design
 **
 ** Permission is hereby granted, free of charge, to any person or organization
 ** obtaining a copy of the software and accompanying documentation covered by
 ** this license (the "Software") to use, reproduce, display, distribute,
 ** execute, and transmit the Software, and to prepare derivative works of the
 ** Software, and to permit third-parties to whom the Software is furnished to
 ** do so, all subject to the following:
 **
 ** The copyright notices in the Software and this entire statement, including
 ** the above license grant, this restriction and the following disclaimer,
 ** must be included in all copies of the Software, in whole or in part, and
 ** all derivative works of the Software, unless such copies or derivative
 ** works are solely in the form of machine-executable object code generated by
 ** a source language processor.
 **
 ** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 ** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 ** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 ** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 ** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 ** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 ** DEALINGS IN THE SOFTWARE.
 ** -LICENSE-END-
 */

#ifndef __CEA708_TYPES_H__
#define __CEA708_TYPES_H__

namespace CEA708
{

// 6.1 Services
enum ServiceNumber
{
	serviceNumber_PrimaryCaptionService = 1
};

// 8.4.1 Window Identifier
enum WindowID
{
	window_0 = 0,
	window_1,
	window_2,
	window_3,
	window_4,
	window_5,
	window_6,
	window_7
};

// 8.4.2 Window Priority
enum Priority
{
	priority_Highest = 0,
	priority_1,
	priority_2,
	priority_3,
	priority_4,
	priority_5,
	priority_6,
	priority_Lowest
};

// 8.4.3 Anchor Points
enum Anchor
{
	anchor_TopLeft = 0,
	anchor_TopCenter,
	anchor_TopRight,
	anchor_LeftMiddle,
	anchor_Middle,
	anchor_RightMiddle,
	anchor_BottomLeft,
	anchor_BottomCenter,
	anchor_BottomRight
};

// 8.4.9.1 Justification
enum Justify
{
	justify_Left = 0,
	justify_Right,
	justify_Center,
	justify_Full
};

// 8.4.9.2 Print Direction
enum PrintDirection
{
	printDirection_LeftToRight = 0,
	printDirection_RightToLeft
};

// 8.4.9.3 Scroll Direction
enum ScrollDirection
{
	scrollDirection_LeftToRight = 0,
	scrollDirection_RightToLeft,
	scrollDirection_TopToBottom,
	scrollDirection_BottomToTop,
};
	
// 8.4.10 Window Display
enum DisplayEffect
{
	displayEffect_Snap = 0,
	displayEffect_Fade,
	displayEffect_Wipe,
};
enum EffectDirection
{
	effectDirection_LeftToRight = 0,
	effectDirection_RightToLeft,
	effectDirection_TopToBottom,
	effectDirection_BottomToTop,
};

// 8.4.11 Window Colors and Borders
enum Opacity
{
	opacity_Solid = 0,
	opacity_Flash,
	opacity_Translucent,
	opacity_Transparent
};
enum BorderType
{
	borderType_None = 0,
	borderType_Raised,
	borderType_Depressed,
	borderType_Uniform,
	borderType_ShadowLeft,
	borderType_ShadowRight
};

// 8.4.12 Predefined Window and Pen Styles
enum WindowStyle
{
	windowStyle_Default = 0,
	windowStyle_NTSCPopup = 1,
	windowStyle_PopupNoBG,
	windowStyle_NTSCCentered,
	windowStyle_NTSCRollup,
	windowStyle_RollupNoBG,
	windowStyle_NTSCCenterRollup,
	windowStyle_TickerTape
};
enum PenStyle
{
	penStyle_Default = 0,
	penStyle_NTSC = 1,
	penStyle_NTSCMonoSerif,
	penStyle_NTSCProportionalSerif,
	penStyle_NTSCMonoSans,
	penStyle_NTSCProportionalSans,
	penStyle_MonoSansBordered,
	penStyle_ProportionalSansBordered
};

// 8.5.1 Pen Size
enum PenSize
{
	penSize_Small = 0,
	penSize_Standard,
	penSize_Large
};

// 8.5.3 Font Styles
enum Font
{
	font_Default = 0,
	font_MonospaceSerif,
	font_ProportionalSerif,
	font_MonospaceSans,
	font_ProportionalSans,
	font_Casual,
	font_Cursive,
	font_SmallCaps
};

// 8.5.4 Character Offsetting
enum TextOffset
{
	textOffset_Subscript = 0,
	textOffset_Normal,
	textOffset_SuperScript
};

// 8.5.8 Character Edges
enum EdgeType
{
	edgeType_None = 0,
	edgeType_Raised,
	edgeType_Depressed,
	edgeType_Uniform,
	edgeType_LeftDropShadow,
	edgeType_RightDropShadow
};

// 8.5.9 Caption Text Function Tags
enum TextTag
{
	textTag_Dialog = 0,
	textTag_Source,
	textTag_ElectronicVoice,
	textTag_SecondaryDialog,
	textTag_Voiceover,
	textTag_AudibleTranslation,
	textTag_SubtitleTranslation,
	textTag_VoiceQualityDescription,
	textTag_SongLyrics,
	textTag_SoundEffectDescription,
	textTag_MusicalScoreDescription,
	textTag_Expletive,
	textTag_undefined12,
	textTag_undefined13,
	textTag_undefined14,
	textTag_TextUndisplayed
};

// CEA-708 - Table 29
enum Colour
{
	colour_Black = 0x0,
	colour_Grey = 0x15,
	colour_White = 0x2A,
	colour_Red = 0x30,
	colour_Green = 0x0C,
	colour_Blue = 0x03,
	colour_Yellow = 0x3C,
	colour_Magenta = 0x33,
	colour_Cyan = 0x0F
};

}

#endif
